<?php

require( getcwd()."/db/table_schemas.inc.php" );

$state = "ok";
$messages = NULL;

if ( is_dir( getcwd()."/configs" ) )   {
    if ( $dh = opendir( getcwd()."/configs" ) )   {

        while ( ( $file = readdir( $dh ) )!==FALSE )   {
            if ( $file!="." && $file!=".." )   {

                $config = json_decode( file_get_contents( getcwd()."/configs/".$file ), true );
                if ( is_array( $config ) && isset( $config["mysqlhost"] ) && !empty( $config["mysqlhost"] ) )   {
                    $id = str_replace( ".json", "", $file );
                    
                    $dblink = mysqli_connect( $config["mysqlhost"], $config["mysqluser"], $config["mysqlpassword"], $config["mysqldatabase"] );
                    $dblink->query( "SET NAMES 'utf8' COLLATE 'utf8_unicode_ci';" );
                    $dblink->query( "SET CHARACTER SET utf8' COLLATE 'utf8_unicode_ci';" );
                    
                    $actual_db = NULL;
                    
                    $dbres = $dblink->query( "SHOW FIELDS FROM `".$config["mysqlprefix"]."regionsdk_".$id."`" );
                    if ( $dbres!==FALSE )   {
                        for ( $i=0; $i<$dbres->num_rows; $i++ )   {
                          $tmp = $dbres->fetch_array( MYSQLI_ASSOC );
                          $actual_db[$tmp["Field"]] = array( "Type" => $tmp["Type"], "Null" => $tmp["Null"], "Key" => $tmp["Key"], "Default" => $tmp["Default"], "Extra" => $tmp["Extra"] );
                          unset( $tmp );
                        };
                    };
                    
                    //echo "check table '".$config["mysqlprefix"]."regionsdk_".$id."'...\n";
                    
                    $schema_matched = NULL;
                    
                    for ( $i=0; $i<count( $table_schemas ); $i++ )   {
                          
                        $differences = NULL;
                            
                        // check existing fields
                        reset( $actual_db );
                        for ( $j=0; $j<count( $actual_db ); $j++ )   {
                            $key_j = key( $actual_db );
                            
                            if ( isset( $table_schemas[$i][$key_j] ) )   {
                                $diff = array_diff( $table_schemas[$i][$key_j], $actual_db[$key_j] );
                                if ( !empty( $diff ) )   {
                                    $differences[$key_j] = $diff;
                                };
                                unset( $diff );
                            } else {
                                $differences[$key_j] = "should not exist";
                            };
                            next( $actual_db );
                        };
                        reset( $actual_db );
                        
                        // check schema fields
                        @reset( $table_schemas[$i] );
                        for ( $j=0; $j<count( $table_schemas[$i] ); $j++ )   {
                            $key_j = key( $table_schemas[$i] );
                            
                            if ( isset( $actual_db[$key_j] ) )   {
                                $diff = array_diff( $actual_db[$key_j], $table_schemas[$i][$key_j] );
                                if ( !empty( $diff ) )   {
                                    $differences[$key_j] = $diff;
                                };
                                unset( $diff );
                            } else {
                                $differences[$key_j] = "does not exist";
                            };
                            next( $table_schemas[$i] );
                        };
                        reset( $table_schemas[$i] );
                        
                        if ( is_null( $differences ) )   {
                            $schema_matched = $i+1;
                            break;
                        };
                        
                        unset( $differences );
                      
                    };
                    
                    if ( is_null( $schema_matched ) )   {
                        $state = "invalid";
                        $messages[] = "table '".$config["mysqlprefix"]."regionsdk_".$id."' is invalid\n";
                        break;
                    } else {
                        if ( $schema_matched !== count( $table_schemas ) )   {
                            $state = "update";
                            if ( isset( $_GET["update"] ) && $_GET["update"]=="1" )   {
                                for ( $j=$schema_matched; $j<count( $table_schemas ); $j++ )   {
                                    if ( !file_exists( getcwd()."/db/update-v".$j."-to-v".(string)($j+1).".inc.php" ) )   {
                                      $state = "updatefail";
                                      $messages[] = "database update file '".getcwd()."/db/update-v".$j."-to-v".(string)($j+1).".inc.php' does not exist";
                                      break;
                                    } else {
                                      $state = "ok";
                                      require( getcwd()."/db/update-v".$j."-to-v".(string)($j+1).".inc.php" );
                                    };
                                };
                            };
                        };
                    };

                    unset( $id );
                    
                    $dblink->close();
                };
                unset( $config );

            };
        };

        closedir( $dh );
    };
};

echo json_encode( array( "state" => $state, "messages" => $messages ) );

unset( $messages );


?>
