/*
  regionsdk 1.0.0
  https://www.regi-on.de/infos/sdk
  Copyright (C) 2019 Cybox GmbH <mail@cybox.net>
*/

function RegionSDK( targetid, options ) {

  this.target = document.getElementById( targetid );
  this.settings = {
    path: null,
    widget: false,
    widgetFilename: 'widget.htm',
    widgetLinkTarget: null,
    loading: '<div class="region-loader"><div></div><div></div><div></div><div></div></div>'
  };

  if( options.path==undefined )   {
    return false;
  };
  this.settings.path = options.path;
  if( options.widget!=undefined && options.widget==true )   {
    this.settings.widget = options.widget;
  };
  if( options.widgetFilename!=undefined )   {
    this.settings.widgetFilename = options.widgetFilename;
  };
  if( options.widgetLinkTarget!=undefined )   {
    this.settings.widgetLinkTarget = options.widgetLinkTarget;
  };
  if( options.loading!=undefined )   {
    this.settings.loading = options.loading;
  };
  
  this.loadPage = function( page )   {
    this.target.classList.add('region-loading');
    this.target.innerHTML = this.settings.loading;
    var that = this;
    var request = new XMLHttpRequest();
    request.open( "GET", page );
    request.addEventListener( 'load', function( evt ) {
      if ( request.status >= 200 && request.status < 300 )   {
          that.target.innerHTML = request.responseText;
      } else {
          that.target.innerHTML = request.statusText;
      }
      that.target.classList.remove('region-loading');
      var tmp = that.target.querySelectorAll('a[href^="'+that.settings.path+'"]');
      for ( var i=0; i<tmp.length; i++ )   {
        tmp[i].addEventListener( 'click', function( evt ) {
          evt.preventDefault();
          that.loadPage( this.getAttribute('href') );
          return false;
        } );
      };
    } );
    request.send();
  };

  this.loadWidget = function( page )   {
    this.target.classList.add('region-loading');
    this.target.innerHTML = this.settings.loading;
    var that = this;
    var request = new XMLHttpRequest();
    request.open( "GET", page );
    request.addEventListener( 'load', function( evt ) {
      if ( request.status >= 200 && request.status < 300 )   {
          that.target.innerHTML = request.responseText;
      } else {
          that.target.innerHTML = request.statusText;
      }
      that.target.classList.remove('region-loading');
      var tmp = that.target.querySelectorAll('a[href^="'+that.settings.path+'"]');
      for ( var i=0; i<tmp.length; i++ )   {
        tmp[i].addEventListener( 'click', function( evt ) {
          evt.preventDefault();
          if ( that.settings.widgetLinkTarget != null )   {
            document.location.href = that.settings.widgetLinkTarget+'#'+this.getAttribute('href');
          } else {
            document.location.href = this.getAttribute('href');
          };
          return false;
        } );
      };
    } );
    request.send();
  };

   if ( this.settings.widget != true )   {
    var jumpto = document.location.href.substring( document.location.href.indexOf("#")+1 );
    if ( jumpto && jumpto.substr(0,this.settings.path.length)==this.settings.path )   {
      this.loadPage( jumpto );
    } else {
      this.loadPage( this.settings.path+'index.htm' );
    };   
  } else {
    this.loadWidget( this.settings.path+this.settings.widgetFilename );
  };
  
};
