<?php

// Version 0.6

class region {

    protected $_cachettl = 86400;
    protected $_canonical = FALSE;
    protected $_dateformat = "%d.%m.%Y";
    protected $_dbhost = NULL;
    protected $_dbusername = NULL;
    protected $_dbpassword = NULL;
    protected $_dbname = NULL;
    protected $_dbtable = NULL;
    protected $_dblink = FALSE;
    protected $_dynamicoutput = FALSE;
    protected $_dynamicurl = "";
    protected $_dynamicparameter = "p";
    protected $_error = NULL;
    protected $_exportid = NULL;
    protected $_linkcss = TRUE;
    protected $_itemsperpage = 5;
    protected $_navtype = "standard";
    protected $_order = "DESC";
    protected $_opengraph = TRUE;
    protected $_page = NULL;
    protected $_previewimagesize = "340x340";
    protected $_regionimagepath = "https://www.regi-on.de/_templates/import/images/";
    protected $_sdkdir = "";
    protected $_targetdirectory = "";
    protected $_targetrelpath = "";
    protected $_templateset = "region-sdk";
    protected $_timeformat = "%H:%M";
    protected $_thousandsdelimiter = ".";
    protected $_twittercard = TRUE;
    protected $_decimal = ",";
    protected $_hideexpiredobjects = TRUE;
    protected $_translations = array(
                                      "next" => "&gt;",
                                      "previous" => "&lt;",
                                      "overview" => "zur Übersicht",
                                      "at" => "am ",
                                      "from" => "vom ",
                                      "till" => "bis ",
                                      "clock" => " Uhr",
                                      "nextpage" => "nächste Seite",
                                      "previouspage" => "vorherige Seite",
                                      "newsnext" => "nächste News",
                                      "newsprevious" => "vorherige News",
                                      "eventsnext" => "nächste Veranstaltung",
                                      "eventsprevious" => "vorherige Veranstaltung",
                                      "offersnext" => "nächste Aktion",
                                      "offersprevious" => "vorherige Aktion",
                                      "backlink" => "zurück",
                                      "overviewlink" => "zur Übersicht",
                                      "readmore" => "lesen Sie mehr...",
                                      "noitems" => "Zur Zeit sind hier leider keine Informationen hinterlegt."
                                    );
    protected $_tupels = NULL;


    public function __construct()   {
    }

    public function __destruct()   {
        if ( is_resource( $this->_dblink ) )   {
            $this->_dblink->close();
        };
    }


    public function getError()   {
        return $this->_error;
    }


    public function getTemplateSet()   {
        return $this->_templateset;
    }


    public function import( $url ) {
        $this->_error = "";

        if ( !preg_match( "/^https:\/\/api\.regi-on\.de\/([a-z0-9]+)\/([a-z0-9]+)\/([0-9]+)\/([a-z0-9]+)\/([0-9]+)$/", $url, $match ) )   {
            $this->_error = "invalid url to xml";
            return FALSE;
        };
        $this->_exportid = $match[5];
        unset( $match );

        if ( file_exists( $this->_targetdirectory."region.xml" ) )   {
            if ( ( time() - filemtime( $this->_targetdirectory."region.xml" ) ) < $this->_cachettl )   {
                return 0;
            };
        };

        if ( !extension_loaded( "curl" ) )   {
            $this->_error = "cURL is not supported";
            return FALSE;
        };

        if ( !extension_loaded( "simplexml" ) )   { 
            $this->_error = "SimpleXML is not supported";
            return FALSE;
        };

        $curl = curl_init();
        curl_setopt( $curl, CURLOPT_URL, $url );
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, TRUE );
        curl_setopt( $curl, CURLOPT_HEADER, FALSE );
        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( "Accept: application/xml" ) );
        curl_setopt( $curl, CURLOPT_HTTPGET, TRUE );
        $xml = curl_exec( $curl );
        if ( $xml === FALSE )   {
            curl_close( $curl );
            unset( $curl );
            $this->_error = curl_strerror( curl_errno( $curl ) );
            return FALSE;
        };

        if ( curl_getinfo( $curl, CURLINFO_HTTP_CODE ) != 200 )   {
            curl_close( $curl );
            unset( $curl );
            $this->_error = "could not load XML";
            return FALSE;
        };

        if ( file_put_contents( $this->_targetdirectory."region.xml", $xml ) === FALSE )   {
            $this->_error = "could not write XML to cache";
            return FALSE;
        };
        unset( $curl );


        $xml = simpleXML_load_string( $xml );
        $data = NULL;
        foreach ( $xml->element as $element )   {
            $data[] = $this->xmlElementToArray( $element );
        };

        if ( is_array( $data ) )   {
            $num_data = count( $data );
            for ( $i=$num_data-1; $i>=0; $i-- )   {
                switch ( $data[$i]["data"]["objecttype"] )   {
                    case "news":  // News
                                  if ( $data[$i]["data"]["image"] == "1" )   {
                                      $this->getImage( $this->_regionimagepath.$data[$i]["data"]["objecttype"]."-image-".$data[$i]["data"]["id"].'-'.$this->_previewimagesize.'.jpg', $this->generateFilename( $data[$i]["guid"] ).".jpg" );
                                      $this->getImage( $this->_regionimagepath.$data[$i]["data"]["objecttype"]."-image-".$data[$i]["data"]["id"].'.jpg', $this->generateFilename( $data[$i]["guid"] )."_full.jpg" );
                                  };
                                  $this->getExternalImages( $data[$i]["data"]["content"] );
                                  break;
                    case "events":  // Events
                                    if ( $data[$i]["data"]["image"] == "1" )   {
                                        $this->getImage( $this->_regionimagepath."veranstaltungen-image-".$data[$i]["data"]["id"].'-'.$this->_previewimagesize.'.jpg', $this->generateFilename( $data[$i]["guid"] ).".jpg" );
                                        $this->getImage( $this->_regionimagepath."veranstaltungen-image-".$data[$i]["data"]["id"].'.jpg', $this->generateFilename( $data[$i]["guid"] )."_full.jpg" );
                                    };
                                    $this->getExternalImages( $data[$i]["data"]["shortdesc"] );
                                    $this->getExternalImages( $data[$i]["data"]["description"] );
                                    $this->getExternalImages( $data[$i]["data"]["organizer"] );
                                    $this->getExternalImages( $data[$i]["data"]["openinghours"] );
                                    break;
                    case "offers":  // Offers
                                    if ( $data[$i]["data"]["image"] == "1" )   {
                                        $this->getImage( $this->_regionimagepath."offers-image-".$data[$i]["data"]["id"].'-'.$this->_previewimagesize.'.jpg', $this->generateFilename( $data[$i]["guid"] ).".jpg" );
                                        $this->getImage( $this->_regionimagepath."offers-image-".$data[$i]["data"]["id"].'.jpg', $this->generateFilename( $data[$i]["guid"] )."_full.jpg" );
                                    };
                                    $this->getExternalImages( $data[$i]["data"]["shortdesc"] );
                                    $this->getExternalImages( $data[$i]["data"]["description"] );
                                    break;
                    default:        continue 2;
                };


                if ( !is_null( $this->_dbhost ) )   {
                    if ( !is_resource( $this->_dblink ) && !$this->connectDB() )   {
                        $this->_error = "Could not access DB";
                        return FALSE;
                    };

                    $version_timestamp = strtotime( (string)$data[$i]["version"] );
                    $version = $this->_dblink->real_escape_string( strftime( "%Y-%m-%d %H:%M:%S", $version_timestamp ) );
                    $data_serialized = $this->_dblink->real_escape_string( serialize( $data[$i] ) );

                    $this->_dblink->query( "INSERT INTO `".$this->_dbtable."` (`guid`,`version`,`data`,`sort`) VALUES('".$data[$i]["guid"]."','".$version."','".$data_serialized."','".$data[$i]["sort"]."');" );
                    if ( $this->_dblink->errno!=0 )   {
                        if ( $this->_dblink->errno == 1062 )   {
                            $res = $this->_dblink->query( "SELECT UNIX_TIMESTAMP(`version`) FROM `".$this->_dbtable."` WHERE `guid`='".$data[$i]["guid"]."';" );
                            $dbversion = $res->fetch_row();
                            unset( $res );
                            if ( $dbversion[0] < $version_timestamp )   {
                                $this->_dblink->query( "UPDATE `".$this->_dbtable."` SET `version`='".$version."', `data`='".$data_serialized."', `sort`='".$data[$i]["sort"]."' WHERE `guid`='".$data[$i]["guid"]."';" );
                                if ( $this->_dblink->errno!=0 )   {
                                    $this->_error = $this->_dblink->error();
                                    return FALSE;
                                };
                            };
                            unset( $dbversion );
                        } else {
                            $this->_error = $this->_dblink->error();
                            return FALSE;
                        };
                    };

                    unset( $data_serialized );
                    unset( $version );
                    unset( $version_timestamp );
                };

            };
        };
        unset( $num_data );
        unset( $data );

        return 1;
    }


    public function setSDKDirectory( $path )   {
        $this->_error = "";

        if ( !is_dir( $path ) )   {
            $this->_error = "directory not found";
            return FALSE;
        };

        if ( $path[strlen( $path )-1] == "/" )   {
            $this->_sdkdir = $path;
        } else  {
            $this->_sdkdir = $path."/";
        };

        return TRUE;
    }


    public function setLinkCSS( $mode )   {
        $this->_error = "";

        if ( !is_bool( $mode ) && !is_string( $mode ) && !( is_string( $mode ) && strlen( $mode )==0 ) )   {
            $this->_error = "given parameter invalid";
            return FALSE;
        };

        $this->_linkcss = $mode;

        return TRUE;
    }


    public function setDynamicOutput( $mode )   {
        $this->_error = "";

        if ( !is_bool( $mode ) && !is_string( $mode ) && !( is_string( $mode ) && strlen( $mode )==0 ) )   {
            $this->_error = "given parameter invalid";
            return FALSE;
        };

        $this->_dynamicoutput = $mode;
        if ( is_bool( $mode ) )   {
            $this->_dynamicurl = "";
        } else {
            if ( strrpos( $mode, "?" ) === FALSE )   {
                $this->_dynamicurl = $mode."?";
            } else {
                $this->_dynamicurl = $mode."&";
            };
        };
        return TRUE;
    }


    public function setDynamicParameter( $name )   {
        $this->_error = "";

        if ( preg_match( "/^([a-z])([a-z])+$/i", $name )!=1 )   {
            $this->_error = "given parameter invalid";
            return FALSE;
        };

        $this->_dynamicparameter = $name;
        return TRUE;
    }


    public function setDateFormat( $format )   {
        if ( preg_match( "/^([\%a-z\ \.\-]+)$/i", $format )!=1 )   {
            $this->_error = "invalid format";
            return FALSE;
        };

        $this->_dateformat = $format;
        return TRUE;
    }


    public function setDB( $dbhost, $dbuser, $dbpassword, $dbname, $dbtable )   {
        $this->_dbhost = $dbhost;
        $this->_dbusername = $dbuser;
        $this->_dbpassword = $dbpassword;
        $this->_dbname = $dbname;
        $this->_dbtable = $dbtable;

        if ( is_resource( $this->_dblink ) )   {
            $this->_dblink->close();
            $this->_dblink = FALSE;
        };

        return TRUE;
    }


    protected function connectDB()   {
        $this->_error = "";

        if ( is_resource( $this->_dblink ) )   {
            return TRUE;
        };

        $this->_dblink = mysqli_connect( $this->_dbhost, $this->_dbusername, $this->_dbpassword, $this->_dbname );
        if ( $this->_dblink === FALSE )   {
            $this->_error = "Could not connect to database";
            return FALSE;
        };
        
        /* TODO: check database */

        $this->_dblink->query( "SET NAMES 'utf8' COLLATE 'utf8_unicode_ci';" );
        $this->_dblink->query( "SET CHARACTER SET utf8" );

        return TRUE;
    }


    public function setTemplateSet( $templateset )   {
        $this->_error = "";

        if ( !file_exists( $this->_sdkdir."templates/".$templateset."/eventdetail.htm" ) )   {
            $this->_error = "Template eventdetail failed";
            return FALSE;
        };

        if ( !file_exists( $this->_sdkdir."templates/".$templateset."/layout.htm" ) )   {
            $this->_error = "Template layout failed";
            return FALSE;
        };

        if ( $this->_linkcss === TRUE && !file_exists( $this->_sdkdir."templates/".$templateset."/style.css" ) )   {
            $this->_error = "CSS should be linked, but does not exist";
            return FALSE;
        };

        if ( !file_exists( $this->_sdkdir."templates/".$templateset."/newsdetail.htm" ) )   {
            $this->_error = "Template newsdetail failed";
            return FALSE;
        };

        if ( !file_exists( $this->_sdkdir."templates/".$templateset."/offerdetail.htm" ) )   {
            $this->_error = "Template offerdetail failed";
            return FALSE;
        };

        if ( !file_exists( $this->_sdkdir."templates/".$templateset."/overview.htm" ) )   {
            $this->_error = "Template overview failed";
            return FALSE;
        };

        if ( !file_exists( $this->_sdkdir."templates/".$templateset."/tupels.htm" ) )   {
            $this->_error = "Template tupels failed";
            return FALSE;
        };

        $this->_templateset = $templateset;
        return TRUE;
    }


    public function setItemsPerPage( $count )   {
        $this->_error = "";

        if ( !is_integer( $count ) )   {
            $this->_error = "Invalid parameter count";
            return FALSE;
        };

        $this->_itemsperpage = $count;
        return TRUE;
    }


    public function setNavType( $type )   {
        if ( !in_array( $type, array( "standard", "cyres" ) ) )   {
            return FALSE;
        };

        $this->_navtype = $type;
        return TRUE;
    }


    public function setOpenGraph( $opengraph )   {
        if ( !is_bool( $opengraph ) )   {
            return FALSE;
        };

        $this->_opengraph = $opengraph;
        return TRUE;
    }
    
    
    public function setTwitterCard( $twittercard )   {
        if ( !is_bool( $twittercard ) )   {
            return FALSE;
        };

        $this->_twittercard = $twittercard;
        return TRUE;
    }
    
    
    public function setOrder( $order )   {
        if ( !in_array( $order, array( "ASC", "DESC" ) ) )   {
            return FALSE;
        };

        $this->_order = $order;
        return TRUE;
    }


    public function setTargetDirectory( $path )   {
        $this->_error = "";

        if ( !is_dir( $path ) )   {
            $this->_error = "Target directory does not exists";
            return FALSE;
        };

        if ( !is_writable( $path ) )   {
            $this->_error = "Target directory is not writable";
            return FALSE;
        };

        if ( $path[strlen( $path )-1] == "/" )   {
            $this->_targetdirectory = $path;
        } else {
            $this->_targetdirectory = $path."/";
        };

        return TRUE;
    }


    public function setCacheTTL( $ttl )   {
        $this->_error = "";

        if ( !is_integer( $ttl ) || $ttl<1800 )   {
            $this->_error = "TTL must be an integer and at least 1800 seconds";
            return FALSE;
        };

        $this->_cachettl = $ttl;

        return TRUE;
    }


    public function setPreviewImageSize( $size )   {
        $this->_error = "";

        if ( !in_array( $size, array( "340x340", "180x180c", "160x160c", "120x120c", "100x100c" ) ) )   {
            $this->_error = "Invalid PreviewImageSize";
            return FALSE;
        };

        $this->_previewimagesize = $size;
        return TRUE;
    }


    public function setTargetRelativePath( $path )   {
        if ( $path[strlen( $path )-1] == "/" )   {
            $this->_targetrelpath = $path;
        } else {
            $this->_targetrelpath = $path."/";
        };

        return TRUE;
    }


    public function setTranslation( $index, $text )   {
        if ( !isset( $this->_translations[$index] ) )   {
            return FALSE;
        };

        $this->_translations[$index] = $text;
        return TRUE;
    }


    public function setTimeFormat( $format )   {
        $this->_error = "";

        if ( preg_match( "/^([\%a-z\ \.\-]+)$/i", $format )!=1 )   {
            $this->_error = "Invalid format";
            return FALSE;
        };

        $this->_timeformat = $format;
        return TRUE;
    }


    public function setNumberFormat( $decimal, $thousandsdelimiter )   {
        $this->_error = "";

        $this->_decimal = $decimal;
        $this->_thousandsdelimiter = $thousandsdelimiter;
        return TRUE;
    }


    public function loadPage()   {
        if ( !isset( $_GET[$this->_dynamicparameter] ) || empty( $_GET[$this->_dynamicparameter] ) )   {
            $page = "index";
        } else {
            if ( preg_match( "/([a-z0-9]+)/", $_GET[$this->_dynamicparameter] ) )   {
                $page = htmlentities( $_GET[$this->_dynamicparameter] );
            } else {
                return FALSE;
            };
        };

        if ( !file_exists( $this->_targetdirectory."/".$page.".htm" ) )   {
            return FALSE;
        };

        $html = file_get_contents( $this->_targetdirectory."/".$page.".htm" );
        if ( $html === FALSE )   {
            return FALSE;
        };
        $this->_canonical = FALSE;
        $this->_page = $html;

        return TRUE;
    }


    public function getCanonical()   {
        if ( preg_match( "/\n\n\<!-- CANONICALURL: (.*?) -->/sU", $this->_page, $match ) )   {
            $this->_page = str_replace( $match[0], "", $this->_page );
            $this->_canonical = TRUE;
            return str_replace( "#URL#", $match[1], $this->getTupel( "TUPEL-CANONICAL" ) );
        };

        $this->_canonical = TRUE;
        return "";
    }


    public function getContent()   {
        if ( $this->_canonical !== TRUE )   {
            return "error - please make sure that you inserted the canonical tag";
        };

        return $this->_page;
    }


    private function generateFilename( $name )   {
         return hash( "sha256", $name );
    }


    private function getExternalImage( $url )   {
        $fileext = pathinfo( $url, PATHINFO_EXTENSION );
        $filename = $this->generateFilename( $url ).".".$fileext;
        if ( $this->getImage( $url, $filename ) === FALSE )   {
            return FALSE;
        } else {
            return $filename;
        };
    }


    private function getExternalImages( $content )   {
        // external images with subtext
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+)\]([\w\W]*)\[\/externalimage\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            $this->getExternalImage( $matches[2][$i] );
        };
        unset( $num_i );
        unset( $matches );

        // external images with subtext and imagezoom
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_])\]([\w\W]*)\[\/externalimage\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            $this->getExternalImage( $matches[2][$i] );
        };
        unset( $num_i );
        unset( $matches );

        // external images with subtext and link
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),url(|intern)=(https:\/\/|http:\/\/|ftp:\/\/|mailto:)([a-zA-Z0-9\@\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_]+)\]([\w\W]*)\[\/externalimage\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            $this->getExternalImage( $matches[2][$i] );
        };
        unset( $num_i );
        unset( $matches );

        // external images
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+)\/\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            $this->getExternalImage( $matches[2][$i] );
        };
        unset( $num_i );
        unset( $matches );

        // external images with imagezoom
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_])\/\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ )   {
            $this->getExternalImage( $matches[2][$i] );
        };
        unset( $num_i );
        unset( $matches );

        // external images with link
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),url(|intern)=(https:\/\/|http:\/\/|ftp:\/\/|mailto:)([a-zA-Z0-9\@\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_]+)\/\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            $this->getExternalImage( $matches[2][$i] );
        };
        unset( $num_i );
        unset( $matches );

        return TRUE;
    }


    private function getImage( $url, $filename )   {
        $this->_error = "";

        if ( !is_dir( $this->_targetdirectory."images/" ) )   {
            mkdir( $this->_targetdirectory."images/" );
        };

        $dest_file_time = NULL;
        if ( file_exists( $filename ) )   {
            $dest_file_time = filemtime( $filename );
        };

        if ( !extension_loaded( "curl" ) )   {
            $this->_error = "cURL is not supported";
            return FALSE;
        };
        $ch = curl_init();
        curl_setopt( $ch, CURLOPT_URL, $url );
        if ( !is_null( $filename ) )   {
            curl_setopt( $ch, CURLOPT_TIMEVALUE, $dest_file_time );
            curl_setopt( $ch, CURLOPT_TIMECONDITION, CURL_TIMECOND_IFMODSINCE );
        };
        curl_setopt( $ch, CURLOPT_FILETIME, TRUE );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, TRUE );
        curl_setopt( $ch, CURLOPT_BINARYTRANSFER, TRUE );
        curl_setopt( $ch, CURLOPT_TIMEOUT, 10 );
        $file = curl_exec( $ch );
        $status = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
        $filetime = curl_getinfo( $ch, CURLINFO_FILETIME );
        if ( curl_errno( $ch )>0 )   {
            return FALSE;
        };
        curl_close( $ch );

        if ( $file !== FALSE && $status == 200 )   {
            $fp = fopen( $this->_targetdirectory."images/".$filename, "wb" );
            if ( $fp === FALSE )   {
                return FALSE;
            };

            fwrite( $fp, $file );
            fclose( $fp );

            if ( $filetime !== FALSE )   {
                touch( $this->_targetdirectory."images/".$filename, $filetime );
            };
        };

        return TRUE;
    }


    private function getTupel( $tupelname )   {
        $this->_error = "";

        if ( is_null( $this->_tupels ) )   {
            $this->loadTupels();
        };
        if ( isset( $this->_tupels[$tupelname] ) )   {
            return $this->_tupels[$tupelname];
        };

        $this->_error = "Tupel ".$tupelname." not found";

        return FALSE;
    }


    private function loadTupels()   {
        if ( !file_exists( $this->_sdkdir."templates/".$this->_templateset."/tupels.htm" ) )   {
            $this->_error = "File ".$this->_sdkdir."templates/".$this->_templateset."/tupels.htm does not exist";
            return FALSE;
        };

        $file = file_get_contents( $this->_sdkdir."templates/".$this->_templateset."/tupels.htm" );

        $converted_pattern = "/".preg_quote( "<!-- TUPEL", "/" )."([0-9A-Z\-]+)(\r\n|\n\r|\n|\r|)(.*?)(\r\n|\n\r|\n|\r|)".preg_quote( "END -->", "/" )."/s";
        preg_match_all( $converted_pattern, $file, $matches );
        unset( $converted_pattern );

        $num_matches = count( $matches[0] );
        for ( $i=0; $i<$num_matches; $i++ )   {
            $this->_tupels["TUPEL".$matches[1][$i]] = $matches[3][$i];
        };
        unset( $num_matches );

        return TRUE;
    }


    private function renderField( $content )   {
        // bold text
        $tupel = $this->getTupel( "TUPEL-TEXT-BOLD" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[b\](.*?)\[\/b\]/s", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $content = str_replace( $matches[0][$i], str_replace( "#TEXT#", $matches[1][$i], $tupel ), $content );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // underline text
        $tupel = $this->getTupel( "TUPEL-TEXT-UNDERLINE" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[u\](.*?)\[\/u\]/s", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $content = str_replace( $matches[0][$i], str_replace( "#TEXT#", $matches[1][$i], $tupel ), $content );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // italic text
        $tupel = $this->getTupel( "TUPEL-TEXT-ITALIC" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[i\](.*?)\[\/i\]/s", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $content = str_replace( $matches[0][$i], str_replace( "#TEXT#", $matches[1][$i], $tupel ), $content );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // sub text
        $tupel = $this->getTupel( "TUPEL-TEXT-SUB" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[sub\](.*?)\[\/sub\]/s", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $content = str_replace( $matches[0][$i], str_replace( "#TEXT#", $matches[1][$i], $tupel ), $content );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // sup text
        $tupel = $this->getTupel( "TUPEL-TEXT-SUP" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[sup\](.*?)\[\/sup\]/s", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $content = str_replace( $matches[0][$i], str_replace( "#TEXT#", $matches[1][$i], $tupel ), $content );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // headlines
        $tupel = $this->getTupel( "TUPEL-HEADLINE" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[headline=([1-6]?)\](.*?)\[\/headline\]\n/m", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $content = str_replace( $matches[0][$i], str_replace( array( "#NO#", "#TEXT#" ), array( $matches[1][$i], $matches[2][$i] ), $tupel ), $content );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // url
        preg_match_all( "/\[url(|intern)\](.*?)\[\/url\]/s", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            if ( $matches[1][$i] == "intern" )   {
                $tupel = $this->getTupel( "TUPEL-URL" );
            } else {
                $tupel = $this->getTupel( "TUPEL-URL-NEW-WINDOW" );
            };
            if ( $tupel === FALSE )   {
                continue;
            };
            $content = str_replace( $matches[0][$i], str_replace( array( "#URL#", "#TEXT#" ), array( $matches[2][$i], $matches[2][$i] ), $tupel ), $content );
            unset( $tupel );
        };
        unset( $num_i );
        unset( $matches );

        preg_match_all( "/\[url(|intern)=(.*?)\]([\w\W]*?)\[\/url\]/s", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            if ( $matches[1][$i] == "intern" )   {
                $tupel = $this->getTupel( "TUPEL-URL" );
            } else {
                $tupel = $this->getTupel( "TUPEL-URL-NEW-WINDOW" );
            };
            if ( $tupel === FALSE )   {
                continue;
            };
            $content = str_replace( $matches[0][$i], str_replace( array( "#URL#", "#TEXT#" ), array( $matches[2][$i], $matches[3][$i] ), $tupel ), $content );
            unset( $tupel );
        };
        unset( $num_i );
        unset( $matches );


        // external images with subtext
        $tupel = $this->getTupel( "TUPEL-IMAGE-WITH-COMMENT" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+)\]([\w\W]*)\[\/externalimage\]/U", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $imagefile = $this->generateFilename( $matches[2][$i] ).".".pathinfo( $matches[2][$i], PATHINFO_EXTENSION );
                if ( !file_exists( $this->_targetdirectory."images/".$imagefile ) )   {
                    $content = str_replace( $matches[0][$i], "", $content );
                } else {
                    $tmp_tupel = $tupel;
                    switch( $matches[1][$i] )   {
                        case "_l":  $tmp_tupel = str_replace( "#ALIGNMENT#", "left", $tmp_tupel );
                                    break;
                        case "_c":  $tmp_tupel = str_replace( "#ALIGNMENT#", "center", $tmp_tupel );
                                    break;
                        case "_r":  $tmp_tupel = str_replace( "#ALIGNMENT#", "right", $tmp_tupel );
                                    break;
                        default:    $tmp_tupel = str_replace( "#ALIGNMENT#", "inline", $tmp_tupel );
                                    break;
                    };
                    $tmp_tupel = str_replace( array( "#SRC#", "#WIDTH#", "#HEIGHT#", "#TEXT#" ), array( $this->_targetrelpath."images/".$imagefile, $matches[3][$i], $matches[4][$i], $matches[5][$i] ), $tmp_tupel );
                    $content = str_replace( $matches[0][$i], $tmp_tupel, $content );
                    unset( $tmp_tupel );
                };
                unset( $imagefile );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // external images with subtext and imagezoom
        $tupel = $this->getTupel( "TUPEL-IMAGE-WITH-COMMENT-AND-ZOOM" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_])\]([\w\W]*)\[\/externalimage\]/U", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $imagefile = $this->generateFilename( $matches[2][$i] ).".".pathinfo( $matches[2][$i], PATHINFO_EXTENSION );
                if ( !file_exists( $this->_targetdirectory."images/".$imagefile ) )   {
                    $content = str_replace( $matches[0][$i], "", $content );
                } else {
                    $tmp_tupel = $tupel;
                    switch( $matches[1][$i] )   {
                        case "_l":  $tmp_tupel = str_replace( "#ALIGNMENT#", "left", $tmp_tupel );
                                    break;
                        case "_c":  $tmp_tupel = str_replace( "#ALIGNMENT#", "center", $tmp_tupel );
                                    break;
                        case "_r":  $tmp_tupel = str_replace( "#ALIGNMENT#", "right", $tmp_tupel );
                                    break;
                        default:    $tmp_tupel = str_replace( "#ALIGNMENT#", "inline", $tmp_tupel );
                                    break;
                    };
                    $tmp_tupel = str_replace( array( "#SRC#", "#WIDTH#", "#HEIGHT#", "#URL#", "#TEXT#" ), array( $this->_targetrelpath."images/".$imagefile, $matches[3][$i], $matches[4][$i], $matches[5][$i], $matches[6][$i] ), $tmp_tupel );
                    $content = str_replace( $matches[0][$i], $tmp_tupel, $content );
                    unset( $tmp_tupel );
                };
                unset( $imagefile );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // external images with subtext and link
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),url(|intern)=(https:\/\/|http:\/\/|ftp:\/\/|mailto:)([a-zA-Z0-9\@\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_]+)\]([\w\W]*)\[\/externalimage\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
                $imagefile = $this->generateFilename( $matches[2][$i] ).".".pathinfo( $matches[2][$i], PATHINFO_EXTENSION );
                if ( !file_exists( $this->_targetdirectory."images/".$imagefile ) )   {
                $content = str_replace( $matches[0][$i], "", $content );
            } else {
                if ( $matches[5][$i] == "intern" )   {
                    $tupel = $this->getTupel( "TUPEL-IMAGE-WITH-COMMENT-AND-LINK" );
                } else {
                    $tupel = $this->getTupel( "TUPEL-IMAGE-WITH-COMMENT-AND-LINK-NEW-WINDOW" );
                };
                if ( $tupel === FALSE )   {
                    continue;
                };
                switch( $matches[1][$i] )   {
                    case "_l":  $tupel = str_replace( "#ALIGNMENT#", "left", $tupel );
                                break;
                    case "_c":  $tupel = str_replace( "#ALIGNMENT#", "center", $tupel );
                                break;
                    case "_r":  $tupel = str_replace( "#ALIGNMENT#", "right", $tupel );
                                break;
                    default:    $tupel = str_replace( "#ALIGNMENT#", "inline", $tupel );
                                break;
                };
                $tupel = str_replace( array( "#SRC#", "#WIDTH#", "#HEIGHT#", "#URL#", "#TEXT#" ), array( $this->_targetrelpath."images/".$imagefile, $matches[3][$i], $matches[4][$i], $matches[6][$i].$matches[7][$i], $matches[8][$i] ), $tupel );
                $content = str_replace( $matches[0][$i], $tupel, $content );
                unset( $tupel );
            };
            unset( $imagefile );
        };
        unset( $num_i );
        unset( $matches );

        // external images
        $tupel = $this->getTupel( "TUPEL-IMAGE" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+)\/\]/U", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ ) {
                $imagefile = $this->generateFilename( $matches[2][$i] ).".".pathinfo( $matches[2][$i], PATHINFO_EXTENSION );
                if ( !file_exists( $this->_targetdirectory."images/".$imagefile ) )   {
                    $content = str_replace( $matches[0][$i], "", $content );
                } else {
                    $tmp_tupel = $tupel;
                    switch( $matches[1][$i] )   {
                        case "_l":  $tmp_tupel = str_replace( "#ALIGNMENT#", "left", $tmp_tupel );
                                    break;
                        case "_c":  $tmp_tupel = str_replace( "#ALIGNMENT#", "center", $tmp_tupel );
                                    break;
                        case "_r":  $tmp_tupel = str_replace( "#ALIGNMENT#", "right", $tmp_tupel );
                                    break;
                        default:    $tmp_tupel = str_replace( "#ALIGNMENT#", "inline", $tmp_tupel );
                                    break;
                    };
                    $tmp_tupel = str_replace( array( "#SRC#", "#WIDTH#", "#HEIGHT#" ), array( $this->_targetrelpath."images/".$imagefile, $matches[3][$i], $matches[4][$i] ), $tmp_tupel );
                    $content = str_replace( $matches[0][$i], $tmp_tupel, $content );
                    unset( $tmp_tupel );
                };
                unset( $imagefile );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // external images with imagezoom
        $tupel = $this->getTupel( "TUPEL-IMAGE-WITH-ZOOM" );
        if ( $tupel !== FALSE )   {
            preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_])\/\]/U", $content, $matches );
            $num_i = count( $matches[0] );
            for ( $i=0;$i<$num_i; $i++ )   {
                $imagefile = $this->generateFilename( $matches[2][$i] ).".".pathinfo( $matches[2][$i], PATHINFO_EXTENSION );
                if ( !file_exists( $this->_targetdirectory."images/".$imagefile ) )   {
                    $content = str_replace( $matches[0][$i], "", $content );
                } else {
                    $tmp_tupel = $tupel;
                    switch( $matches[1][$i] )   {
                        case "_l":  $tmp_tupel = str_replace( "#ALIGNMENT#", "left", $tmp_tupel );
                                    break;
                        case "_c":  $tmp_tupel = str_replace( "#ALIGNMENT#", "center", $tmp_tupel );
                                    break;
                        case "_r":  $tmp_tupel = str_replace( "#ALIGNMENT#", "right", $tmp_tupel );
                                    break;
                        default:    $tmp_tupel = str_replace( "#ALIGNMENT#", "inline", $tmp_tupel );
                                    break;
                    };
                    $tmp_tupel = str_replace( array( "#SRC#", "#WIDTH#", "#HEIGHT#", "#URL#" ), array( $this->_targetrelpath."images/".$imagefile, $matches[3][$i], $matches[4][$i], $matches[5][$i] ), $tmp_tupel );
                    $content = str_replace( $matches[0][$i], $tmp_tupel, $content );
                    unset( $tmp_tupel );
                };
                unset( $imagefile );
            };
            unset( $num_i );
            unset( $matches );
        };
        unset( $tupel );

        // external images with link
        preg_match_all( "/\[externalimage(|_l|_r|_c)=([a-zA-Z]+:\/\/[a-zA-Z0-9\-\.\?\&\=\%\_\/]+),([0-9]+),([0-9]+),url(|intern)=(https:\/\/|http:\/\/|ftp:\/\/|mailto:)([a-zA-Z0-9\@\-\.\?\&\=\%\_\/]+[a-zA-Z0-9\-\.\?\&\=\%\_]+)\/\]/U", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            $imagefile = $this->generateFilename( $matches[2][$i] ).".".pathinfo( $matches[2][$i], PATHINFO_EXTENSION );
            if ( !file_exists( $this->_targetdirectory."images/".$imagefile ) )   {
                $content = str_replace( $matches[0][$i], "", $content );
            } else {
                if ( $matches[5][$i] == "intern" )   {
                    $tupel = $this->getTupel( "TUPEL-IMAGE-WITH-LINK" );
                } else {
                    $tupel = $this->getTupel( "TUPEL-IMAGE-WITH-LINK-NEW-WINDOW" );
                };
                if ( $tupel === FALSE )   {
                    continue;
                };
                switch( $matches[1][$i] )   {
                    case "_l":  $tupel = str_replace( "#ALIGNMENT#", "left", $tupel );
                                break;
                    case "_c":  $tupel = str_replace( "#ALIGNMENT#", "center", $tupel );
                                break;
                    case "_r":  $tupel = str_replace( "#ALIGNMENT#", "right", $tupel );
                                break;
                    default:    $tupel = str_replace( "#ALIGNMENT#", "inline", $tupel );
                                break;
                };
                $tupel = str_replace( array( "#SRC#", "#WIDTH#", "#HEIGHT#", "#URL#" ), array( $this->_targetrelpath."images/".$imagefile, $matches[3][$i], $matches[4][$i], $matches[6][$i].$matches[7][$i] ), $tupel );
                $content = str_replace( $matches[0][$i], $tupel, $content );
                unset( $tupel );
            };
            unset( $imagefile );
        };
        unset( $num_i );
        unset( $matches );

        // youtube
        preg_match_all( "/\[externalvideo=([\-\_0-9A-Za-z]+),([0-9]+),([0-9]+),(youtube)\/\]/s", $content, $matches );
        $num_i = count( $matches[0] );
        for ( $i=0;$i<$num_i; $i++ ) {
            $tupel = $this->getTupel( "TUPEL-VIDEO-".strtoupper( $matches[4][$i] ) );
            if ( $tupel !== FALSE )   {
                $tupel = str_replace( array( "#VIDEO#", "#WIDTH#", "#HEIGHT#" ), array( $matches[1][$i], $matches[2][$i], $matches[3][$i] ), $tupel );
                $content = str_replace( $matches[0][$i], $tupel, $content );
            };
            unset( $tupel );
        };
        unset( $num_i );
        unset( $matches );

        // clear
        $tupel = $this->getTupel( "TUPEL-CLEAR" );
        if ( $tupel !== FALSE )   {
            $content = str_replace( "[clear/]", $tupel, $content );
        };
        unset( $tupel );

        // list
        $start_tags = substr_count( $content, "[list]" );
        $end_tags = substr_count( $content, "[/list]" );

        if ( $start_tags != $end_tags )   {
            $text = str_replace( "[list]", "", $content );
            $text = str_replace( "[*]", "", $content );
            $text = str_replace( "[/list]", "", $content );
            $text = str_replace( "[numlist]", "", $content );
            $text = str_replace( "[/numlist]", "", $content );
            return;
        }

        for( $i=0; $i<$start_tags; $i++ )   {
            $last_start = strrpos( $content, "[list]" );
            $next_end = strpos( $content, "[/list]", ($last_start+6) );
            $text_before = substr( $content, 0, $last_start );
            $text_after = substr( $content, ($next_end+7) );
            $list = substr( $content, $last_start, ($next_end+7)-$last_start );
            $text2 = preg_replace( "/\[list\]([\n ]*)\[\*\]/i", $this->getTupel( "TUPEL-LIST-START" ), $list );
            $text2 = preg_replace( "/\[numlist\]([\n ]*)\[\*\]/i", $this->getTupel( "TUPEL-NUMLIST-START" ), $text2 );
            $text2 = preg_replace( "/([\n]*)\[\/list\]/i", $this->getTupel( "TUPEL-LIST-END" ), $text2 );
            $text2 = preg_replace( "/([\n]*)\[\/numlist\]/i", $this->getTupel( "TUPEL-NUMLIST-END" ), $text2 );
            $text2 = preg_replace( "/([\n]*)\[\*\]/i", $this->getTupel( "TUPEL-LIST-ITEM" ), $text2);
            $content = $text_before.$text2.$text_after;
        }

        // line breaks
        $content = nl2br( $content );

        return $content;
    }


    private function renderLogic( $template, $data )   {

        /* Templatelogik ausfuehren */
        $converted = "/".preg_quote( "<!-- IF ", "/" )."\( (\[([0-9a-zA-ZäÄüÜöÖß.:,\_\-\!\"\=\ ]+)\])(( (&&|\|\|) \[([0-9\pL.:,\_\-\!\"\=\ ]+)\])+|) \) (.*?) ".preg_quote( "ENDIF -->", "/" )."/us";
        preg_match_all( $converted, $template, $matches );
        $num_z = count( $matches[0] );
        for ( $z=0; $z<$num_z; $z++ )   {

            //Auf ungueltige Verwendung der Verknuepfungsoperatoren pruefen
            $operator_and = FALSE;
            $operator_or = FALSE;
            if ( strpos( $matches[3][$z], "&&" )!==FALSE )   {
                $operator_and = TRUE;
            };
            if ( strpos( $matches[3][$z], "||" )!==FALSE  )   {
                $operator_or = TRUE;
            };
            if ( $operator_and===TRUE && $operator_or===TRUE )   {
                $template = str_replace( $matches[0][$z], "", $template );
                continue;
            };
            if ( $operator_and===FALSE && $operator_or===FALSE )   {
                $operator_and = TRUE;
            };

            /* Die einzelnen Bedingungen erfassen */
            if ( $matches[4][$z]=="&&" )   { $operator = TRUE; } else { $operator = FALSE; };
            preg_match_all( "/(\[(([0-9A-Za-z\_]+))(!=|==)(\"([0-9\pL.:,\_\-\ ]+)\"|\"\"|([0-9]+)|([0-9a-z\_]+))\])/u", $matches[1][$z]." ".$matches[3][$z], $conditionals );

            $anzahl_zeichen = strlen( $matches[1][$z]." " );
            for ( $j=1; $j<count( $conditionals[0] ); $j++ )   {
                $anzahl_zeichen += strlen( $conditionals[0][$j] ) + 4;
            };
            if ( $anzahl_zeichen!=strlen( $matches[1][$z]." ".$matches[3][$z] ) )  {
                $template = str_replace( $matches[0][$z], "", $template );
                continue;
            };
            unset( $anzahl_zeichen );

            $abort_syntax = FALSE;
            $counter_abort_conditional = 0;
            $abort_conditional = FALSE;
            for ( $z2=0; $z2<count( $conditionals[0] ); $z2++ )   {
                $abort_conditional = FALSE;

                //Bedingungen erkennen, Syntax und Erfüllung pruefen
                if ( $conditionals[5][$z2]=='""' )   {
                    //Abfrage auf leerer Slot
                    if ( $conditionals[4][$z2]=="==" )   {
                        if ( isset( $data[$conditionals[2][$z2]] ) && !empty( $data[$conditionals[2][$z2]] ) )   { $abort_conditional = TRUE; };
                    } else {
                        if ( !isset( $data[$conditionals[2][$z2]] ) || ( empty( $data[$conditionals[2][$z2]] ) && strlen( $data[$conditionals[2][$z2]] )==0 ) )   { $abort_conditional = TRUE; };
                    };
                } else {
                   if ( strlen( $conditionals[6][$z2] )>0 )   {
                        //Abfrage auf Inhalt
                        if ( $conditionals[4][$z2]=="==" )   {
                            if ( !isset( $data[$conditionals[2][$z2]] ) || strcmp( $data[$conditionals[2][$z2]], $conditionals[6][$z2] )!=0 )   { $abort_conditional = TRUE; };
                        } else {
                            if ( !isset( $data[$conditionals[2][$z2]] ) || strcmp( $data[$conditionals[2][$z2]], $conditionals[6][$z2] )==0 )   { $abort_conditional = TRUE; };
                        };
                    } else {
                        if ( strlen( $conditionals[8][$z2] )>0 )   {
                            //Abfrage auf zwei Slots mit identischem Inhalt
                            if ( $conditionals[4][$z2]=="==" )   {
                                if ( strcmp( $data[$conditionals[2][$z2]], $data[$conditionals[8][$z2]] )!=0 )   { $abort_conditional = TRUE; };
                            } else {
                                if ( strcmp( $data[$conditionals[2][$z2]], $data[$conditionals[8][$z2]] )==0 )   { $abort_conditional = TRUE; };
                            };
                        } else {
                            //Alles andere ist unbekannte Syntax - FEHLER
                            $abort_syntax = TRUE;
                        };
                    };
                };
                if ( $abort_syntax===TRUE )   {
                    break;
                };
                if ( $operator_and===TRUE && $abort_conditional===TRUE )   {
                    break;
                };
                if ( $operator_or===TRUE && $abort_conditional===FALSE )   {
                    $counter_abort_conditional++;
                    break;
                };
            };
            unset( $conditionals );
            if ( $abort_syntax===TRUE || ( $operator_and===TRUE && $abort_conditional===TRUE ) || ( $operator_or===TRUE && $counter_abort_conditional==0 ) )   {
                $template = str_replace( $matches[0][$z], "", $template );
            } else {
                $template = str_replace( $matches[0][$z], $matches[7][$z], $template );
            };
            unset( $counter_abort_conditional );
            unset( $abort_syntax );
            unset( $abort_conditional );
        };
        unset( $matches );
        unset( $num_z );
        unset( $converted );

        return $template;
    }


    public function renderPages()   {
        $this->_error = "";

        if ( $this->_dynamicoutput === TRUE )   {
            return TRUE;
        };

        if ( !is_null( $this->_dbhost ) )   {

            if ( !is_resource( $this->_dblink ) && !$this->connectDB() )   {
                $this->_error = "Could not access DB";
                return FALSE;
            };

            $res = $this->_dblink->query( "SELECT * FROM `".$this->_dbtable."` ORDER BY `sort` ".$this->_order );
            if ( !isset( $res ) || !is_object( $res ) )   {
                unset( $res );
                return FALSE;
            };
            
            $data = NULL;
            for( $i=0; $i<$res->num_rows; $i++ )   {
                $tmp = $res->fetch_array( MYSQLI_ASSOC );
                $tmp = unserialize( $tmp["data"] );
                if ( $tmp === FALSE )   { 
                    $this->_error = "Could not unserialize data";
                    return FALSE;
                };
                $tmp = $this->processData( $tmp );
                if ( $tmp["data"]["objecttype"] == "offers" && $tmp["data"]["expired"] == "1" )   {
                    continue;
                };
                if ( $tmp["data"]["objecttype"] == "events" )   {
                    if ( !empty( $tmp["data"]["endtime"] ) && strtotime( $tmp["data"]["enddate"]." ".$tmp["data"]["endtime"] )<time() )   {
                        continue;
                    } else {
                        if ( strtotime( $tmp["data"]["enddate"]." 23:59:59" )<time() )   {
                            continue;
                        };
                    };
                };
                $data[] = $tmp;
                unset( $tmp );
            };
            $res->close();
            unset( $res );

        } else {

            if ( !file_exists( $this->_targetdirectory."region.xml" ) )   {
                $this->_error = "Unable to load cached xml file, please make sure that you have already ran the import function";
                return FALSE;
            };
            if ( !extension_loaded( "simplexml" ) )   {
                $this->_error = "SimpleXML is not supported";
                return FALSE;
            };
            $xml = simplexml_load_file( $this->_targetdirectory."region.xml" );
            if ( $xml === FALSE )   {
                $this->_error = "Unable to load cached xml file - invalid xml file";
                return FALSE;
            };
            $data = NULL;
            foreach ( $xml->element as $element )   {
                $tmp = $this->processData( $this->xmlElementToArray( $element ) );
                if ( $tmp["data"]["objecttype"] == "offers" && $tmp["data"]["expired"] == "1" )   {
                    continue;
                };
                if ( $tmp["data"]["objecttype"] == "events" )   {
                    if ( !empty( $tmp["data"]["endtime"] ) && strtotime( $tmp["data"]["enddate"]." ".$tmp["data"]["endtime"] )<time() )   {
                        continue;
                    } else {
                        if ( strtotime( $tmp["data"]["enddate"]." 23:59:59" )<time() )   {
                            continue;
                        };
                    };
                };
                $data[] = $tmp;
                unset( $tmp );
            };

            if ( $this->_order === "ASC" )   {
                array_multisort( array_column( $data, "sort" ), SORT_ASC, $data );
            } else {
                array_multisort( array_column( $data, "sort" ), SORT_DESC, $data );
            };

        };

        if ( $this->loadTupels() === FALSE )   {
            return FALSE;
        };

        if ( $this->_dynamicoutput === FALSE )   {
            if ( file_exists( $this->_sdkdir."templates/customlayout_".(string)$this->_exportid.".htm" ) )   {
                $layout = file_get_contents( $this->_sdkdir."templates/customlayout_".(string)$this->_exportid.".htm" );
            } else {
                if ( !file_exists( $this->_sdkdir."templates/".$this->_templateset."/layout.htm" ) )   {
                    $this->_error = "Could not load Template-File '".$this->_sdkdir."templates/".$this->_templateset."/layout.htm"."'";
                    return FALSE;
                };
                $layout = file_get_contents( $this->_sdkdir."templates/".$this->_templateset."/layout.htm" );
            };
            if ( $this->_linkcss === TRUE )   {
                if ( !file_exists( $this->_sdkdir."templates/".$this->_templateset."/style.css" ) )   {
                    $this->_error = "Could not load Template-File '".$this->_sdkdir."templates/".$this->_templateset."/style.css"."'";
                    return FALSE;
                };
                copy( $this->_sdkdir."templates/".$this->_templateset."/style.css", $this->_targetdirectory."style.css" );
                $layout = str_replace( "</head>", "  <link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" media=\"all\"/>\r\n</head>", $layout );
            };
        } else {
            $layout = "#CONTENT#";
        };

        $page = 1;
        $countall = 0;
        $countdone = 0;
        $countonpage = 0;
        $overview = "";

        $num_data = 0;
        if ( is_array( $data ) )   {
            $num_data = count( $data );
        };
        for( $i=0; $i<$num_data; $i++ )   {
            if ( in_array( $data[$i]["data"]["objecttype"], array( "news", "events", "offers" ) ) )   {
                $countall++;
            };
        };
        $pages = ceil( $countall/$this->_itemsperpage );

        switch( $this->_navtype )   {
            case "cyres":     //
                              $tmp_tupelnavigation_cyres_link = $this->getTupel( "TUPEL-NAVIGATION-CYRES-LINK" );
                              if ( $tmp_tupelnavigation_cyres_link === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_link_marked = $this->getTupel( "TUPEL-NAVIGATION-CYRES-LINK-MARKED" );
                              if ( $tmp_tupelnavigation_cyres_link_marked === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_seperator = $this->getTupel( "TUPEL-NAVIGATION-CYRES-SEPERATOR" );
                              if ( $tmp_tupelnavigation_cyres_seperator === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_spacer = $this->getTupel( "TUPEL-NAVIGATION-CYRES-SPACER" );
                              if ( $tmp_tupelnavigation_cyres_spacer === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_forward = $this->getTupel( "TUPEL-NAVIGATION-CYRES-FORWARD" );
                              if ( $tmp_tupelnavigation_cyres_forward === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_forward_link = $this->getTupel( "TUPEL-NAVIGATION-CYRES-FORWARD-LINK" );
                              if ( $tmp_tupelnavigation_cyres_forward_link === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_backward = $this->getTupel( "TUPEL-NAVIGATION-CYRES-BACKWARD" );
                              if ( $tmp_tupelnavigation_cyres_backward === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_backward_link = $this->getTupel( "TUPEL-NAVIGATION-CYRES-BACKWARD-LINK" );
                              if ( $tmp_tupelnavigation_cyres_backward_link === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_numbers = $this->getTupel( "TUPEL-NAVIGATION-CYRES-NUMBERS" );
                              if ( $tmp_tupelnavigation_cyres_numbers === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_detail_numbers = $this->getTupel( "TUPEL-NAVIGATION-CYRES-DETAIL-NUMBERS" );
                              if ( $tmp_tupelnavigation_cyres_detail_numbers === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_detail_right = $this->getTupel( "TUPEL-NAVIGATION-CYRES-DETAIL-RIGHT" );
                              if ( $tmp_tupelnavigation_cyres_detail_right === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_detail_right_link = $this->getTupel( "TUPEL-NAVIGATION-CYRES-DETAIL-RIGHT-LINK" );
                              if ( $tmp_tupelnavigation_cyres_detail_right_link === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_detail_left = $this->getTupel( "TUPEL-NAVIGATION-CYRES-DETAIL-LEFT" );
                              if ( $tmp_tupelnavigation_cyres_detail_left === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_detail_left_link = $this->getTupel( "TUPEL-NAVIGATION-CYRES-DETAIL-LEFT-LINK" );
                              if ( $tmp_tupelnavigation_cyres_detail_left_link === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelnavigation_cyres_detail_backlink = $this->getTupel( "TUPEL-NAVIGATION-CYRES-DETAIL-BACKLINK" );
                              if ( $tmp_tupelnavigation_cyres_detail_backlink === FALSE )   {
                                  return FALSE;
                              };
                              break;
            case "standard":  //
            default:          //
                              $tmp_tupel1 = $this->getTupel( "TUPEL-NAVIGATION" );
                              if ( $tmp_tupel1 === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupel2 = $this->getTupel( "TUPEL-NAVIGATION-INACTIVE" );
                              if ( $tmp_tupel2 === FALSE )   {
                                  return FALSE;
                              };

                              $tmp_tupelposition = $this->getTupel( "TUPEL-NAVIGATION-POSITION" );
                              if ( $tmp_tupelposition === FALSE )   {
                                  return FALSE;
                              };
                              break;
        };

        $tmp_tupelcanonical = $this->getTupel( "TUPEL-CANONICAL" );
        if ( $tmp_tupelcanonical === FALSE )   {
            return FALSE;
        };

        if ( is_null( $data ) )   {
            $html = file_get_contents( $this->_sdkdir."templates/".$this->_templateset."/overview.htm" );
            $html = str_replace( "#OVERVIEW#", "", $html );
            $html = str_replace( "#NAVIGATION#", "", $html );
            $html = str_replace( "#CONTENT#", $this->_translations["noitems"], $layout );
            file_put_contents( $this->_targetdirectory."index.htm", $html );
            unset( $html );
        } else {

            if ( $_SERVER["HTTPS"] == "on" )   {
                $domain_url = "https://".$_SERVER["SERVER_NAME"];
            } else {
                $domain_url = "http://".$_SERVER["SERVER_NAME"];
            };
        
            for( $i=0; $i<$num_data; $i++ )   {
                $render_nav = FALSE;
                
                if ( $this->_opengraph === TRUE || $this->_twittercard === TRUE )   {
                    $opengraph_data = NULL;
                };

                // NEWS rendern
                if ( $data[$i]["data"]["objecttype"] == "news" )   {

                    // Overview-Tupel rendern (NEWS)
                    if ( $data[$i]["data"]["image"] == "1" && file_exists( $this->_targetdirectory."images/".$this->generateFilename( $data[$i]["guid"] ).".jpg" ) )   {
                        $tupel = $this->getTupel( "TUPEL-NEWS-IMAGE" );
                    } else {
                        $tupel = $this->getTupel( "TUPEL-NEWS" );
                    };
                    if ( $tupel === FALSE )   {
                        return FALSE;
                    };
                    
                    if ( $this->_opengraph === TRUE || $this->_twittercard === TRUE )   {
                        $opengraph_data["title"] = $data[$i]["data"]["headline"];
                        $tmp_date = DateTime::createFromFormat( "d.m.Y", $data[$i]["data"]["date"] );
                        $opengraph_data["published"] = $tmp_date->format( DateTime::ATOM );
                        $opengraph_data["url"] = $domain_url.$this->_targetrelpath.$this->generateFilename( $data[$i]["guid"] ).".htm";
                        $opengraph_data["description"] = $data[$i]["data"]["teaser"];
                        if ( $data[$i]["data"]["image"] == "1" && file_exists( $this->_targetdirectory."images/".$this->generateFilename( $data[$i]["guid"] )."_full.jpg" ) )   {
                            if ( $this->_opengraph === TRUE || $this->_twittercard === TRUE )   {
                                $opengraph_data["image"] = $domain_url.$this->_targetrelpath."images/".$this->generateFilename( $data[$i]["guid"] )."_full.jpg";
                            };
                        };
                    };
                    $tupel = $this->renderObject( $tupel, $data[$i] );
                    $overview .= $tupel;
                    unset( $tupel );

                    // Detailseite rendern (NEWS)
                    if ( !file_exists( $this->_sdkdir."templates/".$this->_templateset."/newsdetail.htm" ) )   {
                        $this->_error = "could not load '".$this->_sdkdir."templates/".$this->_templateset."/newsdetail.htm"."'";
                        return FALSE;
                    };
                    $html = file_get_contents( $this->_sdkdir."templates/".$this->_templateset."/newsdetail.htm" );
                    $html = $this->renderObject( $html, $data[$i] );
                    
                    $countonpage++;
                    $countdone++;
                    $render_nav = TRUE;
                };
                // NEWS rendern - ENDE

                // EVENT rendern
                if ( $data[$i]["data"]["objecttype"] == "events" )   {

                    // Overview-Tupel rendern (EVENT)
                    if ( $data[$i]["data"]["image"] == "1" && file_exists( $this->_targetdirectory."images/".$this->generateFilename( $data[$i]["guid"] ).".jpg" ) )   {
                        $tupel = $this->getTupel( "TUPEL-EVENTS-IMAGE" );
                    } else {
                        $tupel = $this->getTupel( "TUPEL-EVENTS" );
                    };
                    if ( $tupel === FALSE )   {
                        return FALSE;
                    };
                    $tupel = $this->renderObject( $tupel, $data[$i] );
                    $overview .= $tupel;
                    unset( $tupel );

                    // Detailseite rendern (EVENT)
                    if ( !file_exists( $this->_sdkdir."templates/".$this->_templateset."/eventdetail.htm" ) )   {
                        $this->_error = "Could not load '".$this->_sdkdir."templates/".$this->_templateset."/eventdetail.htm"."'";
                        return FALSE;
                    };
                    $html = file_get_contents( $this->_sdkdir."templates/".$this->_templateset."/eventdetail.htm" );
                    $html = $this->renderObject( $html, $data[$i] );

                    $countonpage++;
                    $countdone++;
                    $render_nav = TRUE;
                };
                // EVENT rendern - ENDE

                // OFFER rendern
                if ( $data[$i]["data"]["objecttype"] == "offers" )   {

                    // Overview-Tupel rendern (OFFERS)
                    if ( $data[$i]["data"]["image"] == "1" && file_exists( $this->_targetdirectory."images/".$this->generateFilename( $data[$i]["guid"] ).".jpg" ) )   {
                        $tupel = $this->getTupel( "TUPEL-OFFERS-IMAGE" );
                    } else {
                        $tupel = $this->getTupel( "TUPEL-OFFERS" );
                    };
                    if ( $tupel === FALSE )   {
                        return FALSE;
                    };
                    $tupel = $this->renderObject( $tupel, $data[$i] );
                    $overview .= $tupel;
                    unset( $tupel );

                    // Detailseite rendern (OFFER)
                    if ( !file_exists( $this->_sdkdir."templates/".$this->_templateset."/offerdetail.htm" ) )   {
                        $this->_error = "could not load '".$this->_sdkdir."templates/".$this->_templateset."/offerdetail.htm"."'";
                        return FALSE;
                    };
                    $html = file_get_contents( $this->_sdkdir."templates/".$this->_templateset."/offerdetail.htm" );
                    $html = $this->renderObject( $html, $data[$i] );

                    $countonpage++;
                    $countdone++;
                    $render_nav = TRUE;
                };
                // OFFER rendern - ENDE
                
                if ( $render_nav === TRUE )   {
                    $detailnavigation = "";
                    $overviewnavigation = "";

                    switch( $this->_navtype )   {
                        case "cyres":       //

                                            //Detailseitennavigation
                                            if ( $countdone == 1 )   {
                                                $detailnavigation .= str_replace( "#TEXT#", $this->_translations["previous"], $tmp_tupelnavigation_cyres_detail_left );
                                            } else {
                                                $detailnavigation .= str_replace( array( "#URL#", "#TEXT#", "#TITLE#" ), array( $this->_targetrelpath.$this->generateFilename( $data[$i-1]["guid"] ).'.htm', $this->_translations["previous"], $this->_translations[$data[$i-1]["data"]["objecttype"]."previous"] ), $tmp_tupelnavigation_cyres_detail_left_link );
                                            };
                                            $detailnavigation .= str_replace( array( "#INDEX#", "#NUMALL#" ), array( (string)$countdone, (string)$countall ), $tmp_tupelnavigation_cyres_detail_numbers );
                                            if ( $countdone == $countall )   {
                                                $detailnavigation .= str_replace( "#TEXT#", $this->_translations["next"], $tmp_tupelnavigation_cyres_detail_right );
                                            } else {
                                                $detailnavigation .= str_replace( array( "#URL#", "#TEXT#", "#TITLE#" ), array( $this->_targetrelpath.$this->generateFilename( $data[$i+1]["guid"] ).'.htm', $this->_translations["next"], $this->_translations[$data[$i+1]["data"]["objecttype"]."next"] ), $tmp_tupelnavigation_cyres_detail_right_link );
                                            };
                                            if ( $page == 1 )  {
                                                $tmpfilename = "index.htm";
                                            } else {
                                                $tmpfilename = "index-p_".(string)$page.".htm";
                                            };
                                            $detailnavigation .= str_replace( array( "#URL#", "#BACKLINK#", "#OVERVIEWLINK#" ), array( $this->_targetrelpath.$tmpfilename, $this->_translations["backlink"], $this->_translations["overviewlink"] ), $tmp_tupelnavigation_cyres_detail_backlink );
                                            unset( $tmpfilename );

                                            //Uebersichtennavigation
                                            if ( $countonpage >= $this->_itemsperpage || $countdone >= $countall )   {
                                                if ( $pages<11 )   {
                                                    for ( $a1=0; $a1<$pages; $a1++ )   {
                                                        $tmpfilename = "";
                                                        if ( $a1 == 0 )  {
                                                            $tmpfilename = "index.htm";
                                                        } else {
                                                            $tmpfilename = "index-p_".(string)$a1.".htm";
                                                        };
                                                        if ( $page == ($a1+1) )   {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath.$tmpfilename, (string)($a1+1) ), $tmp_tupelnavigation_cyres_link_marked );
                                                        } else {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath.$tmpfilename, (string)($a1+1) ), $tmp_tupelnavigation_cyres_link );
                                                        };
                                                        unset( $tmpfilename );
                                                    }
                                                } else {
                                                    if ( $page == 1 )    {
                                                        $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath."index.htm", "1" ), $tmp_tupelnavigation_cyres_link_marked );
                                                        $startlinks = 2;
                                                    } else {
                                                        $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath."index.htm", "1" ), $tmp_tupelnavigation_cyres_link );
                                                        $z = 0;
                                                        while ( ($page-$z)>2 && $z<4 )   {
                                                            $z++;
                                                        }
                                                        $startlinks = ($page-$z);
                                                    };
                                                    $a2 = 5;
                                                    while( ($page+$a2)>$pages )   { $a2--; }
                                                    $ende = $page + $a2;
                                                    unset( $a2 );
                                                    if ( $page>5 )   { $overviewnavigation .= $tmp_tupelnavigation_cyres_spacer; };
                                                    for ( $a1=$startlinks; $a1<$ende; $a1++ )   {
                                                        if ( $page==$a1 )   {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath."index-p_".($a1-1).".htm", (string)$a1 ), $tmp_tupelnavigation_cyres_link_marked );
                                                        } else {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath."index-p_".($a1-1).".htm", (string)$a1 ), $tmp_tupelnavigation_cyres_link );
                                                        };
                                                    };
                                                    if ( $ende<$pages )   { $overviewnavigation .= $tmp_tupelnavigation_cyres_spacer; };
                                                    if ( $page==$pages )   {
                                                        $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath."index-p_".($pages-1).".htm", (string)$pages ), $tmp_tupelnavigation_cyres_link_marked );
                                                    } else {
                                                        $overviewnavigation .= str_replace( array( "#URL#", "#PAGE#" ), array( $this->_targetrelpath."index-p_".($pages-1).".htm", (string)$pages ), $tmp_tupelnavigation_cyres_link );
                                                    };
                                                    unset( $startlinks );
                                                    unset( $ende );
                                                };

                                                if ( $page == 1 )    {
                                                    $overviewnavigation = str_replace( array( "#TEXT#", "#PREVIOUSPAGE#" ), array( $this->_translations["previous"], $this->_translations["previouspage"] ), $tmp_tupelnavigation_cyres_backward ).$overviewnavigation;
                                                } else {
                                                    if ( $page>2 )  {
                                                        $overviewnavigation = str_replace( array( "#URL#", "#TEXT#", "#PREVIOUSPAGE#" ),  array( $this->_targetrelpath."index-p_".($page-2).".htm", $this->_translations["previous"], $this->_translations["previouspage"] ), $tmp_tupelnavigation_cyres_backward_link ).$overviewnavigation;
                                                    } else {
                                                        $overviewnavigation = str_replace( array( "#URL#", "#TEXT#", "#PREVIOUSPAGE#" ),  array( $this->_targetrelpath."index.htm", $this->_translations["previous"], $this->_translations["previouspage"] ), $tmp_tupelnavigation_cyres_backward_link ).$overviewnavigation;
                                                    };
                                                };
                                                if ( $page < $pages )    {
                                                    $overviewnavigation .= str_replace( array( "#URL#", "#TEXT#", "#NEXTPAGE#" ), array( $this->_targetrelpath."index-p_".($page).".htm", $this->_translations["next"], $this->_translations["nextpage"] ), $tmp_tupelnavigation_cyres_forward_link );
                                                } else {
                                                    $overviewnavigation .= str_replace( array( "#TEXT#", "#NEXTPAGE#" ), array( $this->_translations["next"], $this->_translations["nextpage"] ), $tmp_tupelnavigation_cyres_forward );
                                                };

                                                if ( $countall>0 )   {
                                                    $start = ($page-1)*$this->_itemsperpage;
                                                    $ende = $page*$this->_itemsperpage;
                                                    if ( $ende>$countall )   {
                                                        $ende = $countall-( ($page-2)*$this->_itemsperpage );
                                                    };
                                                    if ( $start == 0 )   {
                                                        $start = 1;
                                                    };
                                                    $overviewnavigation .= str_replace( array( "#NUMALL#", "#START#", "#END#" ), array( (string)$countall, (string)$start, $ende ), $tmp_tupelnavigation_cyres_numbers );
                                                    unset( $start );
                                                    unset( $ende );
                                                };
                                            };
                                            break;


                        case "standard":    //
                        default:            //
                                            //Detailseitennavigation
                                            if ( $countdone == 1 )   {
                                                $detailnavigation .= str_replace( "#TEXT#", $this->_translations["previous"], $tmp_tupel2 );
                                            } else {
                                                if ( $this->_dynamicoutput === FALSE )   {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->generateFilename( $data[$i-1]["guid"] ).'.htm', $this->_translations["previous"] ), $tmp_tupel1 );
                                                } else {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->_dynamicurl.$this->_dynamicparameter."=".$this->generateFilename( $data[$i-1]["guid"] ), $this->_translations["previous"] ), $tmp_tupel1 );
                                                }
                                            };
                                            if ( $page == 1 )   {
                                                if ( $this->_dynamicoutput === FALSE )   {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath."index.htm", $this->_translations["overview"] ), $tmp_tupel1 );
                                                } else {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->_dynamicoutput, $this->_translations["overview"] ), $tmp_tupel1 );
                                                }
                                            } else {
                                                if ( $this->_dynamicoutput === FALSE )   {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.'index-p_'.($page-1).'.htm', $this->_translations["overview"] ), $tmp_tupel1 );
                                                } else {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->_dynamicurl.$this->_dynamicparameter."=index-p_".($page-1), $this->_translations["overview"] ), $tmp_tupel1 );
                                                }
                                            };
                                            if ( $countdone == $countall )   {
                                                $detailnavigation .= str_replace( "#TEXT#", $this->_translations["next"], $tmp_tupel2 );
                                            } else {
                                                if ( $this->_dynamicoutput === FALSE )   {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->generateFilename( $data[$i+1]["guid"] ).'.htm', $this->_translations["next"] ), $tmp_tupel1 );
                                                } else {
                                                    $detailnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->_dynamicurl.$this->_dynamicparameter."=".$this->generateFilename( $data[$i+1]["guid"] ), $this->_translations["next"] ), $tmp_tupel1 );
                                                };
                                            };


                                            if ( $countonpage >= $this->_itemsperpage || $countdone >= $countall )   {
                                                if ( $page > 1 )   {
                                                    if ( $page == 2 )   {
                                                        if ( $this->_dynamicoutput === FALSE )   {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath."index.htm", $this->_translations["previous"] ), $tmp_tupel1 );
                                                        } else {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->_dynamicoutput, $this->_translations["previous"] ), $tmp_tupel1 );
                                                        };
                                                    } else {
                                                        if ( $this->_dynamicoutput === FALSE )   {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.'index-p_'.($page-2).'.htm', $this->_translations["previous"] ), $tmp_tupel1 );
                                                        } else {
                                                            $overviewnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->_dynamicurl.$this->_dynamicparameter."=index-p_".($page-2), $this->_translations["previous"] ), $tmp_tupel1 );
                                                        };
                                                    };
                                                } else {
                                                    $overviewnavigation .= str_replace( "#TEXT#", $this->_translations["previous"], $tmp_tupel2 );
                                                };
                                                $overviewnavigation .= str_replace( array( "#POSITION#", "#NUMALL#" ), array( $page, $pages ), $tmp_tupelposition );
                                                if ( $page < $pages )   {
                                                    if ( $this->_dynamicoutput === FALSE )   {
                                                        $overviewnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath."index-p_".($page).".htm", $this->_translations["next"] ), $tmp_tupel1 );
                                                    } else {
                                                        $overviewnavigation .= str_replace( array( "#URL#", "#TEXT#" ), array( $this->_targetrelpath.$this->_dynamicurl.$this->_dynamicparameter."=index-p_".($page), $this->_translations["next"] ), $tmp_tupel1 );
                                                    };
                                                } else {
                                                    $overviewnavigation .= str_replace( "#TEXT#", $this->_translations["next"], $tmp_tupel2 );
                                                };
                                            };
                                            break;
                    };

                    $html = str_replace( "#NAVIGATION#", $detailnavigation, $html );
                    unset( $detailnavigation );
                    
                    $tmp_opengraph = "";
                    if ( $this->_opengraph === TRUE && !is_null( $opengraph_data ) )   {
                        $tmp_opengraph = "  <!-- OpenGraph -->\n";
                        $tmp_opengraph .= '  <meta property="og:type" content="article"/>'."\n";
                        $tmp_opengraph .= '  <meta property="og:title" content="'.$opengraph_data["title"].'"/>'."\n";
                        if ( isset( $opengraph_data["image"] ) )   {
                            $tmp_opengraph .= '  <meta property="og:image" content="'.$opengraph_data["image"].'"/>'."\n";
                        };
                        $tmp_opengraph .= '  <meta property="article:published_time" content="'.$opengraph_data["published"].'"/>'."\n";
                        $tmp_opengraph .= '  <meta property="og:url" content="'.$opengraph_data["url"].'"/>'."\n";
                        $tmp_opengraph .= '  <meta property="og:locale" content="de_DE"/>'."\n";
                        $tmp_opengraph .= '  <meta property="og:description" content="'.$opengraph_data["description"].'"/>'."\n";
                    };
                    
                    $tmp_twittercard = "";
                    if ( $this->_twittercard === TRUE && !is_null( $opengraph_data ) )   {
                        $tmp_twittercard = "  <!-- Twittercard -->\n";
                        if ( isset( $opengraph_data["image"] ) )   {
                            $tmp_twittercard .= '  <meta name="twitter:card" content="summary_large_image"/>'."\n";
                            $tmp_twittercard .= '  <meta name="twitter:image:src" content="'.$opengraph_data["image"].'"/>'."\n";
                        } else {
                            $tmp_twittercard .= '  <meta name="twitter:card" content="summary"/>'."\n";
                        };
                        $tmp_twittercard .= '  <meta name="twitter:title" content="'.$opengraph_data["title"].'"/>'."\n";
                        $tmp_twittercard .= '  <meta name="twitter:description" content="'.$opengraph_data["description"].'">'."\n";
                    };
                    
                    unset( $opengraph_data );

                    $html = str_replace( array( "#CONTENT#", "</head>" ), array( $html, $tmp_opengraph.$tmp_twittercard."  ".str_replace( "#URL#", $data[$i]["data"]["link"], $tmp_tupelcanonical )."\n</head>" ), $layout );

                    if ( $this->_dynamicoutput === FALSE )   {
                        $html .= "\n\n<!-- CANONICALURL: ".$data[$i]["data"]["link"]." -->";
                    };

                    if ( !file_put_contents( $this->_targetdirectory.$this->generateFilename( $data[$i]["guid"] ).".htm", $html ) )   {
                        return FALSE;
                    };

                    if ( $countonpage >= $this->_itemsperpage || $countdone >= $countall )   {
                        if ( !file_exists( $this->_sdkdir."templates/".$this->_templateset."/overview.htm" ) )   {
                            $this->_error = "could not load '".$this->_sdkdir."templates/".$this->_templateset."/overview.htm"."'";
                            return FALSE;
                        };
                        $html = file_get_contents( $this->_sdkdir."templates/".$this->_templateset."/overview.htm" );
                        $html = str_replace( "#OVERVIEW#", $overview, $html );
                        $html = str_replace( "#NAVIGATION#", $overviewnavigation, $html );
                        $html = str_replace( "#CONTENT#", $html, $layout );
                        if ( $page == 1 )   {
                            file_put_contents( $this->_targetdirectory."index.htm", $html );
                        } else {
                            file_put_contents( $this->_targetdirectory."index-p_".($page-1).".htm", $html );
                        };
                        $overview = "";
                        $page++;
                        $countonpage = 0;
                    };
                };
            };
        };

        unset( $tmp_tupelcanonical );
        unset( $countall );
        unset( $countdone );
        unset( $countonpage );
        unset( $num_data );
        unset( $render_nav );

        switch( $this->_navtype )   {
            case "cyres":     //
                              unset( $tmp_tupelnavigation_cyres_link );
                              unset( $tmp_tupelnavigation_cyres_link_marked );
                              unset( $tmp_tupelnavigation_cyres_seperator );
                              unset( $tmp_tupelnavigation_cyres_spacer );
                              unset( $tmp_tupelnavigation_cyres_forward );
                              unset( $tmp_tupelnavigation_cyres_forward_link );
                              unset( $tmp_tupelnavigation_cyres_backward );
                              unset( $tmp_tupelnavigation_cyres_backward_link );
                              unset( $tmp_tupelnavigation_cyres_numbers );
                              unset( $tmp_tupelnavigation_cyres_detail_numbers );
                              unset( $tmp_tupelnavigation_cyres_detail_right );
                              unset( $tmp_tupelnavigation_cyres_detail_right_link );
                              unset( $tmp_tupelnavigation_cyres_detail_left );
                              unset( $tmp_tupelnavigation_cyres_detail_left_link );
                              unset( $tmp_tupelnavigation_cyres_detail_backlink );
                              break;
            case "standard":  //
            default:          //
                              unset( $tmp_tupel1 );
                              unset( $tmp_tupel2 );
                              unset( $tmp_tupelposition );
                              break;
        };
        return TRUE;
    }


    public function renderWidget()   {
        $this->_error = "";

        if ( $this->_dynamicoutput === TRUE )   {
            return TRUE;
        };

        if ( !is_null( $this->_dbhost ) )   {
            if ( !is_resource( $this->_dblink ) && !$this->connectDB() )   {
                $this->_error = "Could not access DB";
                return FALSE;
            };

            $res = $this->_dblink->query( "SELECT * FROM `".$this->_dbtable."` ORDER BY `sort` ".$this->_order." LIMIT 0, ".(string)$this->_itemsperpage );
            if ( !isset( $res ) || !is_object( $res ) )   {
                unset( $res );
                return FALSE;
            };

            $data = NULL;
            for( $i=0; $i<$res->num_rows; $i++ )   {
                $tmp = $res->fetch_array( MYSQLI_ASSOC );
                $tmp = unserialize( $tmp["data"] );
                if ( $tmp === FALSE )   { 
                    $this->_error = "Could not unserialize data";
                    return FALSE;
                };
                $tmp = $this->processData( $tmp );
                if ( $tmp["data"]["objecttype"] == "offers" && $tmp["data"]["expired"] == "1" )   {
                    continue;
                };
                if ( $tmp["data"]["objecttype"] == "events" )   {
                    if ( !empty( $tmp["data"]["endtime"] ) && strtotime( $tmp["data"]["enddate"]." ".$tmp["data"]["endtime"] )<time() )   {
                        continue;
                    } else {
                        if ( strtotime( $tmp["data"]["enddate"]." 23:59:59" )<time() )   {
                            continue;
                        };
                    };
                };
                $data[$i] = $tmp;
                unset( $tmp );
            };
            $res->close();
            unset( $res );

        } else {

            if ( !file_exists( $this->_targetdirectory."region.xml" ) )   {
                $this->_error = "Unable to load cached xml file, please make sure that you have already ran the import function";
                return FALSE;
            };

            if ( !extension_loaded( "simplexml" ) )   {
                $this->_error = "SimpleXML is not supported";
                return FALSE;
            };

            $xml = simplexml_load_file( $this->_targetdirectory."region.xml" );
            if ( $xml === FALSE )   {
                $this->_error = "Unable to load cached xml file - invalid xml file";
                return FALSE;
            };

            $tmp_data = NULL;
            foreach ( $xml->element as $element )   {
                $tmp_data[] = $this->processData( $this->xmlElementToArray( $element ) );
            };
            $num_tmp_data = count( $tmp_data );
            $data = NULL;
            for ( $i=0; $i<$num_tmp_data; $i++ )   {
                $data[$i] = $tmp_data[$i]; 
            };
            
            if ( $this->_order === "ASC" )   {
                array_multisort( array_column( $data, "sort" ), SORT_ASC, $data );
            } else {
                array_multisort( array_column( $data, "sort" ), SORT_DESC, $data );
            };

        };

        if ( $this->loadTupels() === FALSE )   {
            $this->_error = "Unable to load tupels";
            return FALSE;
        };

        if ( $this->_linkcss === TRUE )   {
            $output = '<script language="javascript" type="text/javascript">var regionSDK=document.createElement("link");regionSDK.rel="stylesheet";regionSDK.href="'.$this->_targetrelpath.$this->_templateset.'.css";regionSDK.media="screen";regionSDK.type="text/css";document.head.appendChild(regionSDK);</script>';
        } else {
            $output = "";
        };

        if ( is_null( $data ) )   {
            return $this->_translations["noitems"];
        } else {
            $num_data = count( $data );
            $rendered_items = 0;

            for ( $i=0; $i<$num_data && $rendered_items<$this->_itemsperpage; $i++ )   {

                if ( $data[$i]["data"]["objecttype"] == "offers" && $data[$i]["data"]["expired"] == "1" )   {
                    continue;
                };
                if ( $data[$i]["data"]["objecttype"] == "events" )   {
                    if ( !empty( $data[$i]["data"]["endtime"] ) && strtotime( $data[$i]["data"]["enddate"]." ".$data[$i]["data"]["endtime"] )<time() )   {
                        continue;
                    } else {
                        if ( strtotime( $data[$i]["data"]["enddate"]." 23:59:59" )<time() )   {
                            continue;
                        };
                    };
                };

                switch ( $data[$i]["data"]["objecttype"] )   {
                    case "news":    //
                    case "events":  //
                    case "offers":  //
                                    if ( $data[$i]["data"]["image"] == "1" && file_exists( $this->_targetdirectory."images/".$this->generateFilename( $data[$i]["guid"] ).".jpg" ) )   {
                                        $tupel = $this->getTupel( "TUPEL-WIDGET-".strtoupper( $data[$i]["data"]["objecttype"] )."-IMAGE" );
                                    } else {
                                        $tupel = $this->getTupel( "TUPEL-WIDGET-".strtoupper( $data[$i]["data"]["objecttype"] ) );
                                    };
                                    $tupel = $this->renderObject( $tupel, $data[$i] );
                                    $output .= $tupel;
                                    $rendered_items++;
                                    unset( $tupel );
                                    break;
                };

            };
            unset( $rendered_items );
            unset( $num_data );
        };

        return $output;
    }


    private function renderObject( $html, $data )   {
        $html = $this->renderLogic( $html, $data["data"] );
        if ( $this->_dynamicoutput === FALSE )   {
            $html = str_replace( "#URL#", $this->_targetrelpath.$this->generateFilename( $data["guid"] ).".htm", $html );
        } else {
            $html = str_replace( "#URL#", $this->_dynamicurl.$this->_dynamicparameter."=".$this->generateFilename( $data["guid"] ), $html );
        }
        $html = str_replace( "#TEXTREADMORE#", $this->_translations["readmore"], $html );
        switch ( $data["data"]["objecttype"] )   {
            case "news":  //
                          $html = str_replace( "#DATE#", $data["data"]["date"], $html );
                          $html = str_replace( "#HEADLINE#", $data["data"]["headline"], $html );
                          $html = str_replace( "#TEASER#", $data["data"]["teaser"], $html );
                          $html = str_replace( "#LATITUDE#", $data["data"]["latitude"], $html );
                          $html = str_replace( "#LONGITUDE#", $data["data"]["longitude"], $html );
                          $html = str_replace( "#LINK#", $data["data"]["link"], $html );
                          $html = str_replace( "#PROFILENAME#", $data["data"]["profilename"], $html );
                          $html = str_replace( "#CONTENT#", $data["data"]["content"], $html );
                          $html = str_replace( "#IMAGE#", $this->_targetrelpath."images/".$this->generateFilename( $data["guid"] ).".jpg", $html );
                          break;
            case "events":  //
                            $tmp_date = "";
                            if ( $data["data"]["startdate"] == $data["data"]["enddate"] )   {
                                $tmp_date .= $this->_translations["at"];
                            } else {
                                $tmp_date .= $this->_translations["from"];
                            };
                            $tmp_date .= $data["data"]["startdate"];
                            if ( !empty( $data["data"]["starttime"] ) )   {
                                $tmp_date .= " ".$data["data"]["starttime"];
                                $tmp_date .= $this->_translations["clock"];
                            };
                            if ( $data["data"]["startdate"] != $data["data"]["enddate"] || ( $data["data"]["starttime"] != $data["data"]["endtime"] && !empty( $data["data"]["endtime"] ) ) )   {
                                $tmp_date .= " ".$this->_translations["till"];
                            };
                            if ( $data["data"]["startdate"] != $data["data"]["enddate"] )   {
                                $tmp_date .= $data["data"]["enddate"];
                            };
                            if ( !empty( $data["data"]["endtime"] ) )   {
                                $tmp_date .= " ".$data["data"]["endtime"];
                                $tmp_date .= $this->_translations["clock"];
                            };
                            $html = str_replace( "#DATE#", $tmp_date, $html );
                            unset( $tmp_date );
                            $html = str_replace( "#TITLE#", $data["data"]["title"], $html );
                            $html = str_replace( "#STARTDATE#", $data["data"]["startdate"], $html );
                            $html = str_replace( "#ENDDATE#", $data["data"]["enddate"], $html );
                            $html = str_replace( "#STARTTIME#", $data["data"]["starttime"], $html );
                            $html = str_replace( "#ENDTIME#", $data["data"]["endtime"], $html );
                            $html = str_replace( "#SHORTDESC#", $data["data"]["shortdesc"], $html );
                            $html = str_replace( "#REGISTRATION#", $data["data"]["registration"], $html );
                            $html = str_replace( "#CLASSIFICATION#", $data["data"]["classification"], $html );
                            $html = str_replace( "#DESCRIPTION#", $data["data"]["description"], $html );
                            $html = str_replace( "#PLACE#", $data["data"]["place"], $html );
                            $html = str_replace( "#ORGANIZER#", $data["data"]["organizer"], $html );
                            $html = str_replace( "#OPENINGHOURS#", $data["data"]["openinghours"], $html );
                            $html = str_replace( "#PRIVATEFUNCTION#", $data["data"]["privatefunction"], $html );
                            $html = str_replace( "#IMAGE#", $this->_targetrelpath."images/".$this->generateFilename( $data["guid"] ).".jpg", $html );
                            $html = str_replace( "#LATITUDE#", $data["data"]["latitude"], $html );
                            $html = str_replace( "#LONGITUDE#", $data["data"]["longitude"], $html );
                            $html = str_replace( "#LINK#", $data["data"]["link"], $html );
                            $html = str_replace( "#PROFILENAME#", $data["data"]["profilename"], $html );
                            break;
            case "offers":  //
                            $html = str_replace( "#START#", $data["data"]["start"], $html );
                            $html = str_replace( "#END#", $data["data"]["end"], $html );
                            $html = str_replace( "#TITLE#", $data["data"]["title"], $html );
                            $html = str_replace( "#WHILESTOCKSLAST#", $data["data"]["whilestockslast"], $html );
                            $html = str_replace( "#SHORTDESC#", $data["data"]["shortdesc"], $html );
                            $html = str_replace( "#DESCRIPTION#", $data["data"]["description"], $html );
                            $html = str_replace( "#PRICEOLD#", $data["data"]["priceold"], $html );
                            $html = str_replace( "#PRICE#", $data["data"]["price"], $html );
                            $html = str_replace( "#DISCOUNT#", $data["data"]["discount"], $html );
                            $html = str_replace( "#SAVING#", $data["data"]["saving"], $html );
                            $html = str_replace( "#IMAGE#", $this->_targetrelpath."images/".$this->generateFilename( $data["guid"] ).".jpg", $html );
                            $html = str_replace( "#FULLIMAGE#", $this->_targetrelpath."images/".$this->generateFilename( $data["guid"] )."_full.jpg", $html );
                            $html = str_replace( "#OVERVIEWIMAGE#", $data["data"]["overviewimage"], $html );
                            $html = str_replace( "#LIMITPERUSER#", $data["data"]["limitperuser"], $html );
                            $html = str_replace( "#QUANTITY#", $data["data"]["quantity"], $html );
                            $html = str_replace( "#LATITUDE#", $data["data"]["latitude"], $html );
                            $html = str_replace( "#LONGITUDE#", $data["data"]["longitude"], $html );
                            $html = str_replace( "#LINK#", $data["data"]["link"], $html );
                            $html = str_replace( "#PROFILENAME#", $data["data"]["profilename"], $html );
                            break;
            default: break;
        };
        return $html;
    }


    private function processData( $data )   {
        if ( !is_array( $data ) )   {
            return FALSE;
        };

        if ( !isset( $data["data"]["latitude"] ) )   {
            $data["data"]["latitude"] = "";
        };

        if ( !isset( $data["data"]["longitude"] ) )   {
            $data["data"]["longitude"] = "";
        };

        switch ( $data["data"]["objecttype"] )   {
            case "news":  //
                          $data["data"]["teaser"] = $this->renderField( $data["data"]["teaser"] );
                          $data["data"]["content"] = $this->renderField( $data["data"]["content"] );
                          $data["data"]["date"] = strftime( $this->_dateformat, strtotime( $data["data"]["date"] ) );
                          break;
            case "events"://
                          $data["data"]["startdate"] = strftime( $this->_dateformat, strtotime( $data["data"]["startdate"]." 00:00:00" ) );
                          $data["data"]["enddate"] = strftime( $this->_dateformat, strtotime( $data["data"]["enddate"]." 00:00:00" ) );
                          if ( !empty( $data["data"]["starttime"] ) )   {
                              $data["data"]["starttime"] = strftime( $this->_timeformat, strtotime( "1970-01-01 ".$data["data"]["starttime"] ) );
                          };
                          if ( !empty( $data["data"]["endtime"] ) )   {
                              $data["data"]["endtime"] = strftime( $this->_timeformat, strtotime( "1970-01-01 ".$data["data"]["endtime"] ) );
                          };
                          $data["data"]["shortdesc"] = $this->renderField( $data["data"]["shortdesc"] );
                          $data["data"]["description"] = $this->renderField( $data["data"]["description"] );
                          $data["data"]["organizer"] = $this->renderField( $data["data"]["organizer"] );
                          $data["data"]["openinghours"] = $this->renderField( $data["data"]["openinghours"] );
                          break;
            case "offers"://
                          $data["data"]["start"] = strftime( $this->_dateformat." ".$this->_timeformat, strtotime( $data["data"]["start"] ) );
                          $data["data"]["end"] = strftime( $this->_dateformat." ".$this->_timeformat, strtotime( $data["data"]["end"] ) );
                          $data["data"]["shortdesc"] = $this->renderField( $data["data"]["shortdesc"] );
                          $data["data"]["description"] = $this->renderField( $data["data"]["description"] );
                          if ( !empty( $data["data"]["priceold"] ) )   {
                              $data["data"]["priceold"] = number_format( (float)str_replace( ",", ".", str_replace( ".", "", $data["data"]["priceold"] ) ), 2, $this->_decimal, $this->_thousandsdelimiter );
                          };
                          if ( !empty( $data["data"]["price"] ) )   {
                              $data["data"]["price"] = number_format( (float)str_replace( ",", ".", str_replace( ".", "", $data["data"]["price"] ) ), 2, $this->_decimal, $this->_thousandsdelimiter );
                          };
                          if ( !empty( $data["data"]["discount"] ) )   {
                              $data["data"]["discount"] = number_format( (float)str_replace( ",", ".", str_replace( ".", "", $data["data"]["discount"] ) ), 2, $this->_decimal, $this->_thousandsdelimiter );
                          };
                          if ( !empty( $data["data"]["saving"] ) )   {
                              $data["data"]["saving"] = number_format( (float)str_replace( ",", ".", str_replace( ".", "", $data["data"]["saving"] ) ), 2, $this->_decimal, $this->_thousandsdelimiter );
                          };
                          break;
            default:      break;
        };
        return $data;
    }


    private function xmlElementToArray( $element )   {
        $data = NULL;
        $data["guid"] = (string)$element->guid;
        $data["data"]["objecttype"] = (string)$element->objecttype;
        $data["data"]["id"] = (string)$element->id;
        $data["version"] = (string)$element->version;

        switch ( $element->objecttype )   {
            case "news":  //
                          $data["data"]["headline"] = (string)$element->headline;
                          $data["data"]["teaser"] = (string)$element->teaser;
                          $data["data"]["content"] = (string)$element->content;
                          $data["data"]["image"] = (string)$element->image;
                          $data["data"]["date"] = (string)$element->date;
                          $data["data"]["profilename"] = (string)$element->profilename;
                          $data["data"]["link"] = (string)$element->link;
                          $data["sort"] = (string)$element->_timestamp;
                          break;
            case "events"://
                          $data["data"]["startdate"] = (string)$element->startdate;
                          $data["data"]["enddate"] = (string)$element->enddate;
                          $data["data"]["starttime"] = (string)$element->starttime;
                          $data["data"]["endtime"] = (string)$element->endtime;
                          $data["data"]["title"] = (string)$element->title;
                          $data["data"]["shortdesc"] = (string)$element->shortdesc;
                          $data["data"]["classification"] = (string)$element->classification;
                          $data["data"]["registration"] = (string)$element->registration;
                          $data["data"]["description"] = (string)$element->description;
                          $data["data"]["place"] = (string)$element->place;
                          $data["data"]["organizer"] = (string)$element->organizer;
                          $data["data"]["openinghours"] = (string)$element->openinghours;
                          $data["data"]["privatefunction"] = (string)$element->privatefunction;
                          $data["data"]["image"] = (string)$element->image;
                          $data["data"]["profilename"] = (string)$element->profilename;
                          $data["data"]["link"] = (string)$element->link;
                          $data["sort"] = (string)$element->_timestamp;
                          break;
            case "offers"://
                          $data["data"]["start"] = (string)$element->start;
                          $data["data"]["end"] = (string)$element->end;
                          $data["data"]["title"] = (string)$element->title;
                          $data["data"]["whilestockslast"] = (string)$element->whilestockslast;
                          $data["data"]["shortdesc"] = (string)$element->shortdesc;
                          $data["data"]["description"] = (string)$element->description;
                          $data["data"]["priceold"] = (string)$element->priceold;
                          $data["data"]["price"] = (string)$element->price;
                          $data["data"]["discount"] = (string)$element->discount;
                          $data["data"]["saving"] = (string)$element->saving;
                          $data["data"]["image"] = (string)$element->image;
                          $data["data"]["overviewimage"] = (string)$element->overviewimage;
                          $data["data"]["limitperuser"] = (string)$element->limitperuser;
                          $data["data"]["quantity"] = (string)$element->quantity;
                          $data["data"]["type"] = (string)$element->type;
                          $data["data"]["profilename"] = (string)$element->profilename;
                          $data["data"]["link"] = (string)$element->link;
                          $data["data"]["expired"] = (string)$element->expired;
                          $data["sort"] = (string)$element->_timestamp;
                          break;

            default: break;
        };

        return $data;
    }
}

?>
